package com.aptana.dtd.core.parsing;

import com.aptana.parsing.WorkingParseResult;
import java.util.ArrayList;
import com.aptana.dtd.core.parsing.ast.*;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ast.IParseRootNode;
import beaver.*;
import com.aptana.parsing.IParser;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.IParseState;

/**
 * This class is a LALR parser generated by
 * <a href="http://beaver.sourceforge.net">Beaver</a> v0.9.6.1
 * from the grammar specification "DTD.grammar".
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
public class DTDParser extends Parser implements IParser {

	static final ParsingTables PARSING_TABLES = new ParsingTables(
		"U9pDbdTyL4KKXS$RtH01aT12G6e02IKX8K0Wf54COEyDx1rxxnXw2xtttdl7WWLxLspOK55" +
		"1KB5X0PN3cTb9N9Q59EWVUVlxzjoPU#VEdPctoG1UBkPWCcPZBLPZ6TPWFCRYDep40Yp6Ke" +
		"p12gp4Sgp3B0p1Q2p24ep32Cp4T4p2Ggp23Cp5A4p1L4p3H4p0FCmlTiRyOcSiWmeu0GCHG" +
		"3IEGrcKmrMu6atWGvl8FlR6NSxZ3niLkVTY7a1bL4SIMk9Ud8ZQk0SLLNSEha4KokFumzfr" +
		"KH$denfwuqwSZZDm9ix2sJW7v#8y4easKqFL6ACQYygrmTPK4wVWRZSoeJ33UcUrHmqCTNQ" +
		"cqsoSYgheYcuORZEa8OFVenckH2LKGIqaenDQOHZkGrCqnnNeYooqG0fIqHgDq1QFuYGqHa" +
		"zfErNQKvKsqQUDrSlqdOkEeZEkmuD8nqLQSNVqmCs8vHf5tuhBSGDkno34SGyQe0xgyGV4e" +
		"mDEHXTSYDDmWNelmRLu1DVZHboAEt0JRi43k1yFuM7qGd#kns3qGPvozSC0U3fHSp9HEgM2" +
		"qp7xOzPMKJjPIMTKHIkkXbYTLPnsfAREgfPEguxEevxgYzUC3RKsiwu4hUB$pzX2kvgYlK$" +
		"LphRM7gLf7zjfdlQQ9xAlgtoHFP5x$O2gRgOJIrHUKtbutU5j4rD7vnIdTOJN2vSfIRayvI" +
		"ugLx2cwjgpQeKZ2pIpqFBhpGhtrbRLPi#26KnDFkrvXjtJQ7qwY4pbDNlkIMEjPSZMRo76Z" +
		"gXYrPFwNRq5QaxIa2vYRQmXHYsVeWDwmxlOa$FPk2pDvRCZC$GsPiblCkIA#ZQYgSuye8$9" +
		"rj566gkghIjW8u2DUR1FFx7Os2L1pmgnHVHrxMr1zUASrdFzoqL$iKDzzKK3sHEaTKKZqJW" +
		"avvTYlxDxEDqUOUwTOUrTXxOzl#i$uDfbd4OxBUSqGLHmTiMGV4OsX#LiSgIz28jh9f94ZC" +
		"krLtPbvojVnDXaKLQak7PBfwbEMuaQpeuIyJBotJohdGuIU#Hhw#8gEKrtcY4oHPR85Zdg$" +
		"4NQqVaxXTJJd7fSteJYhB#qeSUyRrd7EBPxCMBomjexZnAxASIUzX$MD2kiFT$fKgShGtpB" +
		"dUu9wTjnh7D7oBMxX6EtbZ3U$HRGBQIF8VQ#edDuWQFa7#DqRKdgAWtesHWK$iE$k9$x#2V" +
		"$uE$yZNlvArTpbVFgrysVnK$YHnpsy3lkjgg$llo27$CZRkM7$82x#2rtSWU$uTVyYjlbtI" +
		"O#4v#ApyKdTjpxuZs#Q#rt#3RVahx9D$WwN#EhV8KlyoM#wEPwmNu$BvxZPZxBPxY5J$Cfv" +
		"rqdrWgxBcvmlIl52cTl4a#A9yBMyBXuZ7zRM$znk8nBkOGBkO3pEOzpEOUpEOipEOFJEOrJ" +
		"EOMJEOaJEO7ZEOvZEOQZEOeZEOB3EOpv7CeX7Cn17CW1xCz#xCi#NCn5IjzBDnvFGFSUd$1" +
		"qm$cNr2FG2e53w6mf8$pw$stmTDCm#48ujDrSOx8LcoqxKPgeTeuqHsrp$qcoMe2dEvTV17" +
		"GpyGbpL$274D3DmIi24#FNlQA0u1sZZQEj$46YTAyBacxlC7vxwqYJpz15TWl56vBLJbPSY" +
		"jJSeZh95yIpP9PYkXq42pz0m0==");


    private DTDScanner _scanner;
    
	/*
	 * (non-Javadoc)
	 * @see com.aptana.parsing.IParser#parse(com.aptana.parsing.IParseState)
	 */
	protected synchronized void parse(IParseState parseState, WorkingParseResult working) throws java.lang.Exception
	{
		this._scanner = new DTDScanner();

		// send source to the scanner
		this._scanner.setSource(parseState.getSource());

		try
		{
			// parse
			IParseRootNode result = (IParseRootNode) parse(this._scanner);
			
			// save reference to result
			working.setParseResult(result);
		}
		finally
		{
			// loose reference for GC
			this._scanner = null;
		}
	}
	
    public synchronized ParseResult parse(IParseState parseState) throws java.lang.Exception
    {
        WorkingParseResult working = new WorkingParseResult();
        parse(parseState, working);
        return working.getImmutableResult();
    }
    

	protected void addChildren(IParseNode node, ArrayList children)
	{
		if (node != null && children != null)
		{
			for (Object child : children)
			{
				if (child instanceof IParseNode)
				{
					node.addChild((IParseNode) child);
				}
			}
		}
	}

	public DTDParser() {
		super(PARSING_TABLES);


        this._scanner = new DTDScanner();
	}

	protected Symbol invokeReduceAction(int rule_num, int offset) {
		switch(rule_num) {
			case 0: // DTD = Declarations.d
			{
					final Symbol _symbol_d = _symbols[offset + 1];
					final ArrayList _list_d = (ArrayList) _symbol_d.value;
					final beaver.Symbol[] d = _list_d == null ? new beaver.Symbol[0] : (beaver.Symbol[]) _list_d.toArray(new beaver.Symbol[_list_d.size()]);
					
		return new DTDParseRootNode(d);
			}
			case 1: // DTD = 
			{
					
		return new DTDParseRootNode();
			}
			case 2: // Declarations = Declarations Declaration
			{
					((ArrayList) _symbols[offset + 1].value).add(_symbols[offset + 2]); return _symbols[offset + 1];
			}
			case 3: // Declarations = Declaration
			{
					ArrayList lst = new ArrayList(); lst.add(_symbols[offset + 1]); return new Symbol(lst);
			}
			case 11: // MarkupDecl = PI.p
			{
					final Symbol _symbol_p = _symbols[offset + 1];
					final String p = (String) _symbol_p.value;
					
		String content = p.substring(2, p.length() - 2);

		return new DTDProcessingInstructionNode(content);
			}
			case 13: // ElementDecl = ELEMENT NAME.n EMPTY GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			DTDNode decl = new DTDElementDeclNode(n);

			decl.addChild(new DTDEmptyNode());

			return decl;
			}
			case 14: // ElementDecl = ELEMENT NAME.n ANY GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			DTDNode decl = new DTDElementDeclNode(n);

			decl.addChild(new DTDAnyNode());

			return decl;
			}
			case 15: // ElementDecl = ELEMENT NAME.n Mixed.m GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					final Symbol _symbol_m = _symbols[offset + 3];
					final DTDNode m = (DTDNode) _symbol_m.value;
					
			DTDNode decl = new DTDElementDeclNode(n);

			decl.addChild(m);

			return decl;
			}
			case 16: // ElementDecl = ELEMENT NAME.n Children.c GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					final Symbol _symbol_c = _symbols[offset + 3];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			DTDNode decl = new DTDElementDeclNode(n);

			decl.addChild(c);

			return decl;
			}
			case 17: // Mixed = LPAREN PCDATA RPAREN STAR
			{
					
			DTDPCDataNode data = new DTDPCDataNode();
			DTDZeroOrMoreNode zom = new DTDZeroOrMoreNode();

			zom.addChild(data);

			return zom;
			}
			case 18: // Mixed = LPAREN PCDATA PIPE Names.n RPAREN STAR
			{
					final Symbol _symbol_n = _symbols[offset + 4];
					final ArrayList n = (ArrayList) _symbol_n.value;
					
			DTDPCDataNode data = new DTDPCDataNode();
			DTDZeroOrMoreNode zom = new DTDZeroOrMoreNode();

			zom.addChild(data);
			this.addChildren(zom, n);

			return zom;
			}
			case 19: // Mixed = LPAREN PCDATA RPAREN
			{
					
			return new DTDPCDataNode();
			}
			case 20: // Names = Names PIPE NAME
			{
					
			String name = (String) _symbols[offset + 3].value;
			DTDElementNode element = new DTDElementNode(name);
			((ArrayList) _symbols[offset + 1].value).add(element);

			return _symbols[offset + 1];
			}
			case 21: // Names = NAME
			{
					
			ArrayList lst = new ArrayList();
			String name = (String) _symbols[offset + 1].value;
			DTDElementNode element = new DTDElementNode(name);

			lst.add(element);

			return new Symbol(lst);
			}
			case 23: // Children = Choice.c QUESTION
			{
					final Symbol _symbol_c = _symbols[offset + 1];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			DTDOptionalNode result = new DTDOptionalNode();

			result.addChild(c);

			return result;
			}
			case 24: // Children = Choice.c STAR
			{
					final Symbol _symbol_c = _symbols[offset + 1];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			DTDZeroOrMoreNode result = new DTDZeroOrMoreNode();

			result.addChild(c);

			return result;
			}
			case 25: // Children = Choice.c PLUS
			{
					final Symbol _symbol_c = _symbols[offset + 1];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			DTDOneOrMoreNode result = new DTDOneOrMoreNode();

			result.addChild(c);

			return result;
			}
			case 27: // Children = Seq.s QUESTION
			{
					final Symbol _symbol_s = _symbols[offset + 1];
					final DTDNode s = (DTDNode) _symbol_s.value;
					
			DTDOptionalNode result = new DTDOptionalNode();

			result.addChild(s);

			return result;
			}
			case 28: // Children = Seq.s STAR
			{
					final Symbol _symbol_s = _symbols[offset + 1];
					final DTDNode s = (DTDNode) _symbol_s.value;
					
			DTDZeroOrMoreNode result = new DTDZeroOrMoreNode();

			result.addChild(s);

			return result;
			}
			case 29: // Children = Seq.s PLUS
			{
					final Symbol _symbol_s = _symbols[offset + 1];
					final DTDNode s = (DTDNode) _symbol_s.value;
					
			DTDOneOrMoreNode result = new DTDOneOrMoreNode();

			result.addChild(s);

			return result;
			}
			case 30: // Choice = LPAREN Cp.c ChoiceCps RPAREN
			{
					final Symbol _symbol_c = _symbols[offset + 2];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			ArrayList cps = (ArrayList) _symbols[offset + 3].value;
			DTDOrExpressionNode result = new DTDOrExpressionNode();

			// pre-pend leading cp
			cps.add(0, c);

			// add all children to or-expr
			this.addChildren(result, cps);

			return result;
			}
			case 31: // ChoiceCps = ChoiceCps PIPE Cp.c
			{
					final Symbol _symbol_c = _symbols[offset + 3];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			((ArrayList) _symbols[offset + 1].value).add(c);

			return _symbols[offset + 1];
			}
			case 32: // ChoiceCps = PIPE Cp
			{
					
			ArrayList lst = new ArrayList();

			lst.add(_symbols[offset + 2]);

			return new Symbol(lst);
			}
			case 33: // Seq = LPAREN Cp.c RPAREN
			{
					final Symbol _symbol_c = _symbols[offset + 2];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			return c;
			}
			case 34: // Seq = LPAREN Cp.c SeqCps RPAREN
			{
					final Symbol _symbol_c = _symbols[offset + 2];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			ArrayList cps = (ArrayList) _symbols[offset + 3].value;
			DTDAndExpressionNode result = new DTDAndExpressionNode();

			// pre-pend leading cp
			cps.add(0, c);

			// add all children to or-expr
			this.addChildren(result, cps);

			return result;
			}
			case 35: // SeqCps = SeqCps COMMA Cp.c
			{
					final Symbol _symbol_c = _symbols[offset + 3];
					final DTDNode c = (DTDNode) _symbol_c.value;
					
			((ArrayList) _symbols[offset + 1].value).add(c);

			return _symbols[offset + 1];
			}
			case 36: // SeqCps = COMMA Cp
			{
					
			ArrayList lst = new ArrayList();

			lst.add(_symbols[offset + 2]);

			return new Symbol(lst);
			}
			case 37: // Cp = NAME.n
			{
					final Symbol _symbol_n = _symbols[offset + 1];
					final String n = (String) _symbol_n.value;
					
			return new DTDElementNode(n);
			}
			case 38: // Cp = NAME.n QUESTION
			{
					final Symbol _symbol_n = _symbols[offset + 1];
					final String n = (String) _symbol_n.value;
					
			DTDOptionalNode node = new DTDOptionalNode();

			node.addChild(new DTDElementNode(n));
			}
			case 39: // Cp = NAME.n STAR
			{
					final Symbol _symbol_n = _symbols[offset + 1];
					final String n = (String) _symbol_n.value;
					
			DTDZeroOrMoreNode node = new DTDZeroOrMoreNode();

			node.addChild(new DTDElementNode(n));
			}
			case 40: // Cp = NAME.n PLUS
			{
					final Symbol _symbol_n = _symbols[offset + 1];
					final String n = (String) _symbol_n.value;
					
			DTDOneOrMoreNode node = new DTDOneOrMoreNode();

			node.addChild(new DTDElementNode(n));
			}
			case 42: // AttlistDecl = ATTLIST NAME.n GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			return new DTDAttListDeclNode(n);
			}
			case 43: // AttlistDecl = ATTLIST NAME.n AttDefs GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			Symbol _symbol_a = _symbols[offset + 3];
			ArrayList defs = (ArrayList) _symbol_a.value;
			DTDAttListDeclNode result = new DTDAttListDeclNode(n);

			this.addChildren(result, defs);

			return result;
			}
			case 44: // AttDefs = AttDefs AttDef
			{
					((ArrayList) _symbols[offset + 1].value).add(_symbols[offset + 2]); return _symbols[offset + 1];
			}
			case 45: // AttDefs = AttDef
			{
					ArrayList lst = new ArrayList(); lst.add(_symbols[offset + 1]); return new Symbol(lst);
			}
			case 46: // AttDef = NAME.n AttType.t REQUIRED.m
			{
					final Symbol _symbol_n = _symbols[offset + 1];
					final String n = (String) _symbol_n.value;
					final Symbol _symbol_t = _symbols[offset + 2];
					final DTDNode t = (DTDNode) _symbol_t.value;
					final Symbol _symbol_m = _symbols[offset + 3];
					final String m = (String) _symbol_m.value;
					
			return new DTDAttributeNode(n, t, m);
			}
			case 47: // AttDef = NAME.n AttType.t IMPLIED.m
			{
					final Symbol _symbol_n = _symbols[offset + 1];
					final String n = (String) _symbol_n.value;
					final Symbol _symbol_t = _symbols[offset + 2];
					final DTDNode t = (DTDNode) _symbol_t.value;
					final Symbol _symbol_m = _symbols[offset + 3];
					final String m = (String) _symbol_m.value;
					
			return new DTDAttributeNode(n, t, m);
			}
			case 48: // AttDef = NAME.n AttType.t STRING.m
			{
					final Symbol _symbol_n = _symbols[offset + 1];
					final String n = (String) _symbol_n.value;
					final Symbol _symbol_t = _symbols[offset + 2];
					final DTDNode t = (DTDNode) _symbol_t.value;
					final Symbol _symbol_m = _symbols[offset + 3];
					final String m = (String) _symbol_m.value;
					
			return new DTDAttributeNode(n, t, m.substring(1, m.length() - 1));
			}
			case 49: // AttDef = NAME.n AttType.t FIXED.m1 STRING.m2
			{
					final Symbol _symbol_n = _symbols[offset + 1];
					final String n = (String) _symbol_n.value;
					final Symbol _symbol_t = _symbols[offset + 2];
					final DTDNode t = (DTDNode) _symbol_t.value;
					final Symbol _symbol_m1 = _symbols[offset + 3];
					final String m1 = (String) _symbol_m1.value;
					final Symbol _symbol_m2 = _symbols[offset + 4];
					final String m2 = (String) _symbol_m2.value;
					
			return new DTDAttributeNode(n, t, m1 + " " + m2.substring(1, m2.length() - 1));
			}
			case 50: // AttType = CDATA_TYPE.t
			{
					final Symbol t = _symbols[offset + 1];
					
			return new DTDTypeNode((String) t.value);
			}
			case 51: // AttType = ID_TYPE.t
			{
					final Symbol t = _symbols[offset + 1];
					
			return new DTDTypeNode((String) t.value);
			}
			case 52: // AttType = IDREF_TYPE.t
			{
					final Symbol t = _symbols[offset + 1];
					
			return new DTDTypeNode((String) t.value);
			}
			case 53: // AttType = IDREFS_TYPE.t
			{
					final Symbol t = _symbols[offset + 1];
					
			return new DTDTypeNode((String) t.value);
			}
			case 54: // AttType = ENTITY_TYPE.t
			{
					final Symbol t = _symbols[offset + 1];
					
			return new DTDTypeNode((String) t.value);
			}
			case 55: // AttType = ENTITIES_TYPE.t
			{
					final Symbol t = _symbols[offset + 1];
					
			return new DTDTypeNode((String) t.value);
			}
			case 56: // AttType = NMTOKEN_TYPE.t
			{
					final Symbol t = _symbols[offset + 1];
					
			return new DTDTypeNode((String) t.value);
			}
			case 57: // AttType = NMTOKENS_TYPE.t
			{
					final Symbol t = _symbols[offset + 1];
					
			return new DTDTypeNode((String) t.value);
			}
			case 58: // AttType = NOTATION_TYPE LPAREN Names RPAREN
			{
					
			// TODO: add Names
			return new DTDNotationTypeNode();
			}
			case 59: // AttType = LPAREN NmTokens RPAREN
			{
					
			// TODO: add NmTokens
			return new DTDEnumerationTypeNode();
			}
			case 66: // GEDecl = ENTITY NAME.n STRING GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			return new DTDGeneralEntityDeclNode(n);
			}
			case 67: // GEDecl = ENTITY NAME.n ExternalID GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			return new DTDGeneralEntityDeclNode(n);
			}
			case 68: // GEDecl = ENTITY NAME.n ExternalID NDataDecl.nd GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					final Symbol _symbol_nd = _symbols[offset + 4];
					final DTDNode nd = (DTDNode) _symbol_nd.value;
					
			DTDGeneralEntityDeclNode result = new DTDGeneralEntityDeclNode(n);

			result.addChild(nd);

			return result;
			}
			case 69: // PEDecl = ENTITY PERCENT NAME.n STRING.s GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 3];
					final String n = (String) _symbol_n.value;
					final Symbol _symbol_s = _symbols[offset + 4];
					final String s = (String) _symbol_s.value;
					
			String value = s.substring(1, s.length() - 1);
			this._scanner.register(n, value);

			return new DTDParsedEntityDeclNode(n);
			}
			case 70: // PEDecl = ENTITY PERCENT NAME.n ExternalID GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 3];
					final String n = (String) _symbol_n.value;
					
			return new DTDParsedEntityDeclNode(n);
			}
			case 73: // NDataDecl = NDATA NAME.n
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			return new DTDNDataDeclNode(n);
			}
			case 74: // NotationDecl = NOTATION NAME.n ExternalID GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			return new DTDNotationDeclNode(n);
			}
			case 75: // NotationDecl = NOTATION NAME.n PublicID GREATER_THAN
			{
					final Symbol _symbol_n = _symbols[offset + 2];
					final String n = (String) _symbol_n.value;
					
			return new DTDNotationDeclNode(n);
			}
			case 79: // IncludeSect = SECTION_START INCLUDE LBRACKET SECTION_END
			{
					
			return new DTDIncludeSectionNode();
			}
			case 80: // IncludeSect = SECTION_START INCLUDE LBRACKET Declarations.d SECTION_END
			{
					final Symbol _symbol_d = _symbols[offset + 4];
					final ArrayList _list_d = (ArrayList) _symbol_d.value;
					final beaver.Symbol[] d = _list_d == null ? new beaver.Symbol[0] : (beaver.Symbol[]) _list_d.toArray(new beaver.Symbol[_list_d.size()]);
					
			DTDIncludeSectionNode result = new DTDIncludeSectionNode();

			for (Symbol s : d)
			{
				Object v = s.value;

				if (v instanceof IParseNode)
				{
					result.addChild((IParseNode) v);
				}
			}

			return result;
			}
			case 81: // IgnoreSect = SECTION_START IGNORE LBRACKET SECTION_END
			{
					
			return new DTDIgnoreSectionNode();
			}
			case 82: // IgnoreSect = SECTION_START IGNORE LBRACKET IgnoreSectionBody SECTION_END
			{
					
			return new DTDIgnoreSectionNode();
			}
			case 4: // Declaration = MarkupDecl
			case 5: // Declaration = PE_REF
			case 6: // Declaration = ConditionalSect
			case 7: // MarkupDecl = ElementDecl
			case 8: // MarkupDecl = AttlistDecl
			case 9: // MarkupDecl = EntityDecl
			case 10: // MarkupDecl = NotationDecl
			case 12: // MarkupDecl = COMMENT
			case 22: // Children = Choice
			case 26: // Children = Seq
			case 41: // Cp = Children
			case 62: // NmTokens = NMTOKEN
			case 63: // NmTokens = NAME
			case 64: // EntityDecl = GEDecl
			case 65: // EntityDecl = PEDecl
			case 77: // ConditionalSect = IncludeSect
			case 78: // ConditionalSect = IgnoreSect
			case 85: // IgnoreSectionBody = IgnoreToken
			case 86: // IgnoreSectionBody = ConditionalSect
			case 87: // IgnoreToken = ANY
			case 88: // IgnoreToken = ATTLIST
			case 89: // IgnoreToken = CDATA_TYPE
			case 90: // IgnoreToken = COMMA
			case 91: // IgnoreToken = COMMENT
			case 92: // IgnoreToken = ELEMENT
			case 93: // IgnoreToken = EMPTY
			case 94: // IgnoreToken = ENTITY
			case 95: // IgnoreToken = ENTITIES_TYPE
			case 96: // IgnoreToken = ENTITY_TYPE
			case 97: // IgnoreToken = FIXED
			case 98: // IgnoreToken = GREATER_THAN
			case 99: // IgnoreToken = ID_TYPE
			case 100: // IgnoreToken = IDREF_TYPE
			case 101: // IgnoreToken = IDREFS_TYPE
			case 102: // IgnoreToken = IGNORE
			case 103: // IgnoreToken = IMPLIED
			case 104: // IgnoreToken = INCLUDE
			case 105: // IgnoreToken = LBRACKET
			case 106: // IgnoreToken = LPAREN
			case 107: // IgnoreToken = NAME
			case 108: // IgnoreToken = NDATA
			case 109: // IgnoreToken = NMTOKEN_TYPE
			case 110: // IgnoreToken = NMTOKENS_TYPE
			case 111: // IgnoreToken = NOTATION
			case 112: // IgnoreToken = NOTATION_TYPE
			case 113: // IgnoreToken = PCDATA
			case 114: // IgnoreToken = PE_REF
			case 115: // IgnoreToken = PERCENT
			case 116: // IgnoreToken = PI
			case 117: // IgnoreToken = PIPE
			case 118: // IgnoreToken = PLUS
			case 119: // IgnoreToken = PUBLIC
			case 120: // IgnoreToken = QUESTION
			case 121: // IgnoreToken = REQUIRED
			case 122: // IgnoreToken = RPAREN
			case 123: // IgnoreToken = STAR
			case 124: // IgnoreToken = STRING
			case 125: // IgnoreToken = SYSTEM
			{
				return _symbols[offset + 1];
			}
			case 71: // ExternalID = SYSTEM STRING
			case 76: // PublicID = PUBLIC STRING
			case 83: // IgnoreSectionBody = IgnoreSectionBody IgnoreToken
			case 84: // IgnoreSectionBody = IgnoreSectionBody ConditionalSect
			{
				return _symbols[offset + 2];
			}
			case 60: // NmTokens = NmTokens PIPE NMTOKEN
			case 61: // NmTokens = NmTokens PIPE NAME
			case 72: // ExternalID = PUBLIC STRING STRING
			{
				return _symbols[offset + 3];
			}
			default:
				throw new IllegalArgumentException("unknown production #" + rule_num);
		}
	}
}
